package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.ConflictExperienceMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceEpisodeMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceSiteRecordMetaData;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * 
 * @author DNS   ruizc
 *
 */
public class MilitaryServiceSiteRecordMetaDataFromMSDS implements
		MilitaryServiceSiteRecordMetaData {

	private MilitaryServiceSiteRecord militaryServiceSiteRecord = null;
	private MilitaryServiceEpisodeMetaData[] militaryServiceEpisodes = null;
	
	public MilitaryServiceSiteRecordMetaDataFromMSDS(MilitaryServiceEpisodeMetaData[] episodes) {
		super();
		
		this.militaryServiceEpisodes = episodes;
	}
	
	public ConflictExperienceMetaData[] getConflictExperiences() {
		// Not provided by MSDS
		return null;
	}

	public MilitaryServiceSiteRecord getEntity() {
		
		return this.militaryServiceSiteRecord;
	}

	public String getFilipinoVeteranProof() {
		// Not provided by MSDS
		return null;
	}

	public MilitaryServiceEpisodeMetaData[] getMilitaryServiceEpisodes() {
		return this.militaryServiceEpisodes;
	}

	public String getServicePeriod() {
		// TODO Auto-generated method stub
		return null;
	}

	public String getSite() {
		return VAFacility.CODE_HEC.getCode();
	}

	public void setEntity(MilitaryServiceSiteRecord entity) {
		this.militaryServiceSiteRecord = entity;
	}

}
