package gov.va.med.esr.common.builder.msds;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import gov.va.med.esr.common.builder.entity.ActivationMetaData;
import gov.va.med.esr.common.builder.entity.CombatEpisodeMetaData;
import gov.va.med.esr.common.builder.entity.CombatServiceMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceEpisodeMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceSiteRecordMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.service.MsdsResponseInfo;
import gov.va.med.esr.jms.vadir.outboundResponse.VadirServiceResponseWrapper;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryHistory;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.PeriodOfService;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.BIRLS;
import gov.va.med.fw.util.StringUtils;


/**
 * 
 * @author DNS   ruizc
 *
 */
public class MilitaryServiceMetaDataFromBIRLS extends AbstractMetaData
		implements MilitaryServiceMetaDataMSDS {

	private MilitaryService militaryService = null;
	private MilitaryServiceSiteRecordMetaData militaryServiceSiteRecordMetaData = null;
	private ActivationMetaData[] activations = null;
	private CombatServiceMetaData[] combatServices = null;
	private CombatEpisodeMetaData[] combatEpisodes = null;	
	private BIRLS birls = null;
	private String metaDataError = null;
	
	public MilitaryServiceMetaDataFromBIRLS(VadirServiceResponseWrapper wrapper) {
        super();

        // unwrap the wrapper
        processWrapper(wrapper);
	}

	public ActivationMetaData[] getActivations() {
		return this.activations;
	}

	public CombatServiceMetaData[] getCombatServices() {
		return this.combatServices;
	}

	public CombatEpisodeMetaData[] getCombatEpisodes() {
		return this.combatEpisodes;
	}

	public String getCombatVeteranEligibilityEndDate() {
		return null;
	}

	public String getDisabilityRetirementStatus() {
		return null;
	}

	public String getDischargeDueToDisability() {
		return this.birls != null ? this.birls.getDisabilityInd() : null;
	}

	public MilitaryService getEntity() {
		return this.militaryService;
	}

	public MilitaryServiceSiteRecordMetaData getMilitaryServiceSiteRecord() {
		return this.militaryServiceSiteRecordMetaData;
	}

	public void setEntity(MilitaryService entity) {
		this.militaryService = entity;
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.builder.msds.MilitaryServiceMetaDataMSDS#getMetaDataError()
	 */
	public String getMetaDataError() {
		return this.metaDataError;
	}
	
	/**
	 * @param metaDataError the metaDataError to set
	 */
	public void setMetaDataError(String metaDataError) {
		this.metaDataError = metaDataError;
	}

	private void processWrapper(VadirServiceResponseWrapper wrapper) {
		List militaryPays = new ArrayList();
		List combatEpisodeList = new ArrayList();		
		List activations = new ArrayList();
		List servicePeriodsHEC = new ArrayList();
		
		MilitaryHistory history = wrapper != null ?	(MilitaryHistory)wrapper.getResult() : null;

		if (history != null) {
			this.birls = history.getBirls();

			List periodOfServices = birls != null ? birls.getPeriodOfService() : new ArrayList();
			if (periodOfServices != null) {
				for (Iterator iter = periodOfServices.iterator(); iter.hasNext();) {
					PeriodOfService period = (PeriodOfService)iter.next();
					if (period.getCharacterOfService() == null || 
							StringUtils.isBlank(period.getCharacterOfService()) ||
							"UNK".equals(period.getCharacterOfService()) ||
							"Z".equals(period.getCharacterOfService())) {
						this.setMetaDataError(MsdsResponseInfo.INVALID_CHARACTER_OF_SERVICE_BIRLS);						
					}

					// Military Service Episodes
					MilitaryServiceEpisodeMetaData periodMeta = new MilitaryServiceEpisodeMetaDataFromBIRLS(period);
					servicePeriodsHEC.add(periodMeta);
				}
			}
		}

		this.combatServices = (CombatServiceMetaData[])militaryPays.toArray(new CombatServiceMetaData[0]);
		this.combatEpisodes = (CombatEpisodeMetaData[])combatEpisodeList.toArray(new CombatEpisodeMetaData[0]);		
 		this.militaryServiceSiteRecordMetaData = 
			new MilitaryServiceSiteRecordMetaDataFromMSDS((MilitaryServiceEpisodeMetaData[])
					servicePeriodsHEC.toArray(new MilitaryServiceEpisodeMetaData[0]));
		this.activations = (ActivationMetaData[])activations.toArray(new ActivationMetaData[0]);		
	}
}
