package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.MilitaryServiceEpisodeMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod;

/**
 * 
 * @author DNS   ruizc
 *
 */
public class MilitaryServiceEpisodeMetaDataFromVADIR extends AbstractMetaData implements
		MilitaryServiceEpisodeMetaData {

	
	private MilitaryServiceEpisode militaryServiceEpisode = null;
	private ServicePeriod servicePeriod = null;
	
	public MilitaryServiceEpisodeMetaDataFromVADIR(
			gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod 
			servicePeriod) {
        super();
        
        this.servicePeriod = servicePeriod;
	}
	
	public String getDischargeType() {
		return this.servicePeriod != null ? 
				this.servicePeriod.getCharacterOfService() : null;
	}

	public String getEndDate() {
		return (this.servicePeriod != null) ?
				getStandardDate(this.servicePeriod.getEndDate()) : null;
	}

	public MilitaryServiceEpisode getEntity() {
		return this.militaryServiceEpisode;
	}

	public String getServiceBranch() {
		return this.servicePeriod != null ? this.servicePeriod.getBranchOfService() : null;
	}

	public String getServiceComponent() {
		return this.servicePeriod != null ? servicePeriod.getPersonnelCategory() : null;
	}

	public String getServiceNumber() {
		// VADIR returns list and not specific value for period
		return null;
	}

	public String getStartDate() {
		return (this.servicePeriod != null) ?
				getStandardDate(this.servicePeriod.getStartDate()) : null;
	}

	public void setEntity(MilitaryServiceEpisode entity) {
		this.militaryServiceEpisode = entity;
	}

}
