package gov.va.med.esr.common.builder.msds;

import java.lang.String;
import gov.va.med.esr.common.builder.entity.MilitaryServiceEpisodeMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.PeriodOfService;

/**
 * 
 * @author DNS   ruizc
 *
 */
public class MilitaryServiceEpisodeMetaDataFromBIRLS extends AbstractMetaData
		implements MilitaryServiceEpisodeMetaData {

	private MilitaryServiceEpisode militaryServiceEpisode = null;	
	private PeriodOfService periodOfService = null;	
	
	public MilitaryServiceEpisodeMetaDataFromBIRLS(
			gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.PeriodOfService 
			periodOfService) {
        super();
        
        this.periodOfService = periodOfService;
	}		

	public String getDischargeType() {
		return this.periodOfService != null ? 
				this.periodOfService.getCharacterOfService() : null;
	}

	public String getEndDate() {
		return (this.periodOfService != null) ?
				getStandardDate(this.periodOfService.getReleasedActiveDutyDate()) : null;
	}

	public MilitaryServiceEpisode getEntity() {
		return this.militaryServiceEpisode;
	}

	public String getServiceBranch() {
		return this.periodOfService != null ? this.periodOfService.getBranchOfService() : null;
	}

	public String getServiceComponent() {
		// CCR 10681
		if (this.periodOfService != null) {
			String bos = this.getServiceBranch();
			if ("ANG".equals(bos) || "ARNG".equals(bos) ) {
				return "G";
			}
		}
		// customer has not defined a default value for Regular yet
		return null; 
	}

	public String getServiceNumber() {
		// none provided
		return null;
	}

	public String getStartDate() {
		return (this.periodOfService != null) ?
				getStandardDate(this.periodOfService.getEnteredOnDutyDate()) : null;
	}

	public void setEntity(MilitaryServiceEpisode entity) {
		this.militaryServiceEpisode = entity;
	}
}
