package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.DeploymentMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.ee.Deployment;
import gov.va.med.esr.common.model.lookup.MHDataSource;

/**
 * 
 * @author DNS   ruizc
 *
 */
public class DeploymentMetaDataFromMSDS extends AbstractMetaData implements DeploymentMetaData {

	private Deployment deployment = null;
	private gov.va.med.esr.jms.vadir.outboundResponse.model.
	militaryHistory.Deployment dep = null;
	
	public DeploymentMetaDataFromMSDS(
			gov.va.med.esr.jms.vadir.outboundResponse.model.
			militaryHistory.Deployment dep) {
		super();
		
		this.dep = dep;
	}
	
	public String getCountry() {
		// MSDS_CodeCR10606 - disable
		return this.dep != null ? verifyNullString(): null;
		//return null;
	}

	public String getDataSource() {
		return this.dep != null ? MHDataSource.VADIR.getCode() : null;
	}

	public String getDeploymentBeginDate() {
		return this.dep != null ? 
				this.getStandardDate(dep.getStartDate()) : null;
	}

	public String getDeploymentEndDate() {
		return this.dep != null ? 
				this.getStandardDate(dep.getEndDate()) : null;
	}

	public Deployment getEntity() {
		return this.deployment;
	}

	public String getSpecialOperation() {
		return this.dep != null ? this.dep.getSpecialOperation() : null;
	}

	public String getTerminationReason() {
		return this.dep != null ? this.dep.getTerminationRsn() : null;
	}

	public void setEntity(Deployment entity) {
		this.deployment = entity;
	}
	
	private String verifyNullString(){
		
		if(this.dep.getLocation() != null && dep.getLocation().equalsIgnoreCase("null")){
			return null;
		}
		else{
			return this.dep.getLocation();			
		}
		
	}
}
