package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.DeploymentMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.model.ee.Deployment;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.MHDataSource;
import gov.va.med.esr.common.model.lookup.MsdsCountry;
import gov.va.med.esr.common.model.lookup.SpecialOperation;
import gov.va.med.esr.common.model.lookup.TerminationReason;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * 
 * @author DNS   ruizc
 *
 */
public class DeploymentBuilder extends EntityBuilder {

	/**
	 * 
	 */
	private static final long serialVersionUID = -4209467969311775385L;
	private Builder countryBuilder;
	private Builder mhDataSourceBuilder;
    private Builder specialOperationBuilder;   	
    private Builder terminationReasonBuilder;    
	
	public Deployment build(DeploymentMetaData metaData) throws BuilderException {
		Deployment input = metaData.getEntity();
		Deployment output = (input == null) ? new Deployment() : input;

		//copy data from meta data to object
		this.transfer(output, metaData);

		//verify for minimum required data
		return this.shouldKeep(output) ? output : null;
	}	

	private void transfer(Deployment input, DeploymentMetaData metaData) 
		throws BuilderException {

		// add transfer
		input.setCountry((MsdsCountry)super.build(countryBuilder, 
				input.getCountry(), metaData.getCountry()));
		input.setDataSource((MHDataSource)super.build(mhDataSourceBuilder, 
				input.getDataSource(), metaData.getDataSource()));
		input.setSpecialOperation((SpecialOperation)super.build(specialOperationBuilder, 
				input.getSpecialOperation(), metaData.getSpecialOperation()));
		input.setDeploymentBeginDate(super.build(input.getDeploymentBeginDate(), 
				metaData.getDeploymentBeginDate()));
		input.setDeploymentEndDate(super.build(input.getDeploymentEndDate(), 
				metaData.getDeploymentEndDate()));
		input.setTerminationReason((TerminationReason)super.build(terminationReasonBuilder, 
				input.getTerminationReason(), metaData.getTerminationReason()));
	}

	/**
	 * @return the countryBuilder
	 */
	public Builder getCountryBuilder() {
		return countryBuilder;
	}

	/**
	 * @param countryBuilder the countryBuilder to set
	 */
	public void setCountryBuilder(Builder countryBuilder) {
		this.countryBuilder = countryBuilder;
	}

	/**
	 * @return the mhDataSourceBuilder
	 */
	public Builder getMhDataSourceBuilder() {
		return mhDataSourceBuilder;
	}

	/**
	 * @param mhDataSourceBuilder the mhDataSourceBuilder to set
	 */
	public void setMhDataSourceBuilder(Builder mhDataSourceBuilder) {
		this.mhDataSourceBuilder = mhDataSourceBuilder;
	}

	/**
	 * @return the specialOperationBuilder
	 */
	public Builder getSpecialOperationBuilder() {
		return specialOperationBuilder;
	}

	/**
	 * @param specialOperationBuilder the specialOperationBuilder to set
	 */
	public void setSpecialOperationBuilder(Builder specialOperationBuilder) {
		this.specialOperationBuilder = specialOperationBuilder;
	}

	/**
	 * @return the terminationReasonBuilder
	 */
	public Builder getTerminationReasonBuilder() {
		return terminationReasonBuilder;
	}

	/**
	 * @param terminationReasonBuilder the terminationReasonBuilder to set
	 */
	public void setTerminationReasonBuilder(Builder terminationReasonBuilder) {
		this.terminationReasonBuilder = terminationReasonBuilder;
	}		
	
}
