package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.CombatServiceMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.lookup.CombatServiceSource;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryPay;

/**
 * 
 * @author DNS   ruizc
 *
 */
public class CombatServiceMetaDataFromMSDS extends AbstractMetaData implements CombatServiceMetaData {
	private MilitaryPay pay = null;
	private CombatService combatService = null;
	
	public CombatServiceMetaDataFromMSDS(ServicePeriod period,
			gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryPay milPay) {
        super();
     
        this.processMSDSwrapper(period, milPay);
	}
	
	public String getCombatPayType() {
		return this.pay != null ? this.pay.getPayType() : null;
	}

	public String getCombatServiceLocation() {
		// MSDS_CodeCR10606 - disabled
		
		return this.pay != null ? verifyNullString() : null;		
		
	}
	
	private String verifyNullString(){
		
		if(this.pay.getCombatServiceLocation() != null && pay.getCombatServiceLocation().equalsIgnoreCase("null")){
			return null;
		}
		else{
			return this.pay.getCombatServiceLocation();			
		}
		
	}

	public String getCombatServiceSource() {
		// This only comes from VADIR
		return CombatServiceSource.CODE_VADIR.getCode();
	}

	public CombatService getEntity() {
		return this.combatService;
	}

	public String getPayEndDate() {
		return (this.pay != null) ?
				getStandardDate(this.pay.getEndDate()) : null;
	}

	public String getPayStartDate() {
		return (this.pay != null) ?
				getStandardDate(this.pay.getStartDate()) : null;
	}

	public void setEntity(CombatService entity) {
		this.combatService = entity;
	}
	private void processMSDSwrapper(ServicePeriod period,  
			gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryPay pay) {

		this.pay = pay;
	}
}
