package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.CombatServiceMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.lookup.CombatPayType;
import gov.va.med.esr.common.model.lookup.CombatServiceLocation;
import gov.va.med.esr.common.model.lookup.CombatServiceSource;
import gov.va.med.esr.common.model.lookup.MsdsCountry;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * 
 * @author DNS   ruizc
 *
 */
public class CombatServiceBuilder extends EntityBuilder {

	/**
	 * 
	 */
	private static final long serialVersionUID = -1905196331490835589L;
	private Builder combatPayTypeBuilder;
	private Builder combatCountryBuilder;
	private Builder combatServiceSourceBuilder;	
	
	public CombatService build(CombatServiceMetaData metaData) throws BuilderException {
		CombatService input = metaData.getEntity();
		CombatService output = (input == null) ? new CombatService() : input;

		//copy data from meta data to object
		this.transfer(output, metaData);

		//verify for minimum required data
		return this.shouldKeep(output) ? output : null;
	}	

	private void transfer(CombatService input, CombatServiceMetaData metaData) 
		throws BuilderException {

		input.setCombatPayType((CombatPayType)super.build(combatPayTypeBuilder, 
				input.getCombatPayType(), metaData.getCombatPayType()));
		input.setMsdsCountry((MsdsCountry)super.build(combatCountryBuilder, 
				input.getMsdsCountry(), metaData.getCombatServiceLocation()));
		input.setCombatServiceSource((CombatServiceSource)super.build(combatServiceSourceBuilder, 
				input.getCombatServiceSource(), metaData.getCombatServiceSource()));
		// It is not obvious here, but VADIR will always return precise dates
		input.setPayStartDate(super.build(input.getPayStartDate(), metaData.getPayStartDate()));
		input.setPayEndDate(super.build(input.getPayEndDate(), metaData.getPayEndDate()));
		
	}

	/**
	 * @return the combatPayTypeBuilder
	 */
	public Builder getCombatPayTypeBuilder() {
		return combatPayTypeBuilder;
	}

	/**
	 * @param combatPayTypeBuilder the combatPayTypeBuilder to set
	 */
	public void setCombatPayTypeBuilder(Builder combatPayTypeBuilder) {
		this.combatPayTypeBuilder = combatPayTypeBuilder;
	}

	/**
	 * @return the combatCountryBuilder
	 */
	public Builder getCombatCountryBuilder() {
		return combatCountryBuilder;
	}

	/**
	 * @param combatCountryBuilder the combatCountryBuilder to set
	 */
	public void setCombatCountryBuilder(Builder combatCountryBuilder) {
		this.combatCountryBuilder = combatCountryBuilder;
	}

	/**
	 * @return the combatServiceSourceBuilder
	 */
	public Builder getCombatServiceSourceBuilder() {
		return combatServiceSourceBuilder;
	}

	/**
	 * @param combatServiceSourceBuilder the combatServiceSourceBuilder to set
	 */
	public void setCombatServiceSourceBuilder(Builder combatServiceSourceBuilder) {
		this.combatServiceSourceBuilder = combatServiceSourceBuilder;
	}		
	
}
