package gov.va.med.esr.common.builder.msds;


import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.lookup.OEFOIFSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryPay;

/**
 * Implementation of meta data specific to Combat Episode from MSDS.
 *  
 * @author DNS   ruizc
 *
 */
public class CombatEpisodeMetaDataFromVADIR extends AbstractMetaData implements
		CombatEpisodeMetaDataInterfaceForMSDS {

	private CombatEpisode combatEpisode = null;
	private MilitaryPay militaryPay = null;	
	private String location = null;
	private ImpreciseDate startDate = null;
	private ImpreciseDate endDate = null;
	
	public CombatEpisodeMetaDataFromVADIR(MilitaryPay milPay, 
			String location, ImpreciseDate calculatedStartDate, ImpreciseDate calculatedEndDate) {
        super();
     
       this.militaryPay = milPay;
       this.location = location;
       this.startDate = calculatedStartDate;
       this.endDate = calculatedEndDate;
	}	
	
	public String getConflictLocation() {
		return this.location;
	}

	public String getEndDate() {
		return this.endDate != null?  this.endDate.getStandardFormat() : null;
	}

	public CombatEpisode getEntity() {
		return this.combatEpisode;
	}

	public String getFacility() {
		return VAFacility.CODE_HEC.getCode();
	}

	public String getSource() {
		return OEFOIFSource.CODE_VETERAN_INFORMATION_SYSTEM.getCode();
	}

	public String getStartDate() {
		return this.startDate != null?  this.startDate.getStandardFormat() : null;
	}

	public String getCombatPayType() {
		return this.militaryPay.getPayType();
	}

	public void setEntity(CombatEpisode entity) {
		this.combatEpisode = entity;
	}
}
