package gov.va.med.esr.common.builder.msds;

import java.util.Date;
import java.util.List;

import gov.va.med.esr.common.infra.ImpreciseDate;
/**
 * Interface for strategy object that will apply 
 * business algorithms to determine certain Combat Episode
 * values.
 * 
 * @author DNS   ruizc
 *
 */
public interface CombatEpisodeBuilderStrategy {
    public String determineConflictLocationCode();
    public ImpreciseDate determineStartDate();    
    public ImpreciseDate determineEndDate();
    public void setCombatPayEnd(Date combatPayEnd);
    public void setCombatPayStart(Date combatPayStart);
    public void setDeployments(List deployments);
}
