package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.CombatPayType;
import gov.va.med.esr.common.model.lookup.OEFOIFSource;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.util.builder.BuilderException;
import gov.va.med.fw.service.ServiceException;

/*
 * This builder is specifically for MSDS. Extending the regular 
 * CombatEpisode builder was not an option since Junit gets confused
 * during autoload of beans. 
 * Most of the behavior differences are in the "transfer" method.
 * 
 */
public class CombatEpisodeBuilderForMSDS extends EntityBuilder {
	/**
	 * 
	 */
	private static final long serialVersionUID = -4397343617673790771L;
	private LookupService lookupService = null;

    /**
     * Default constructor.
     */
    public CombatEpisodeBuilderForMSDS()
    {
        super();
    }


	public CombatEpisode build(CombatEpisodeMetaDataInterfaceForMSDS metaData)
        throws BuilderException
    {
    	CombatEpisode input = metaData.getEntity();
    	CombatEpisode output = (input == null) ? new CombatEpisode() : input;

    	//copy data from meta data to object
        this.transfer(output, metaData);

        //verify for minimum required data
        return this.shouldKeep(output) ? output : null;
    }
   
    private boolean shouldKeep(CombatEpisode obj)
    {
    	//Conflict location, start date and end date are required
    	if (obj.getStartDate() == null || 
    			obj.getEndDate() == null || 
    			obj.getConflictLocation() == null)
    		return false;
    	else
    		return true;
    }
    
    private ConflictLocation buildConflict(String code)
    	throws BuilderException {
    	try {
    		return this.getLookupService().getConflictByCode(code);    		
    	} catch (ServiceException e) {
    		throw new BuilderException("Invalid Conflict Location: " 
    				+ code, e);    		
    	}
    }    

    private void transfer(CombatEpisode input, 
    		CombatEpisodeMetaDataInterfaceForMSDS metaData) throws BuilderException {
    	//dates
    	input.setEndDate(super.build(input.getEndDate(), metaData.getEndDate()));
        input.setStartDate(super.build(input.getStartDate(), metaData.getStartDate()));
        
        //combat location
        input.setConflictLocation(this.buildConflict(metaData.getConflictLocation()));
        
        try {
        	input.setOEFOIFSource((OEFOIFSource)this.getLookupService().getByCode(
        			OEFOIFSource.class, metaData.getSource()));    			
        }  catch (ServiceException e) {
        	throw new BuilderException("Invalid OEFOIFSource: " + e);    		
        }

        
        
        String code = metaData.getCombatPayType(); 
        if (code != null) {
        	try {
        		if (CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION.getCode().equals(code)) {
        			input.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
        		}
        		else
        			if (CombatPayType.CODE_HOSTILE_FIRE_IMMINENT_DANGER.getCode().equals(code)) {
        				input.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_HOSTILE_FIRE_IMMINENT_DANGER));
        			}        		
        	}  catch (ServiceException e) {
        		throw new BuilderException("Invalid CombatPayType: " 
        				+ code, e);    		
        	}
        }
        	
        //vaFacilityBuilder
        if (metaData.getFacility() != null) {
        	input.setOEFOIFStationNumber(
        		(VAFacility)getVaFacilityBuilder().build(metaData.getFacility()));
        }
    }

	public LookupService getLookupService() {
		return lookupService;
	}

	public void setLookupService(LookupService lookupService) {
		this.lookupService = lookupService;
	}

}
