package gov.va.med.esr.common.builder.msds;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;

import gov.va.med.esr.common.builder.entity.ActivationMetaData;
import gov.va.med.esr.common.builder.entity.DeploymentMetaData;
import gov.va.med.esr.common.builder.msds.DeploymentMetaDataFromMSDS;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.Activation;
import gov.va.med.esr.common.model.lookup.MHDataSource;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.Deployment;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod;
import gov.va.med.fw.util.StringUtils;

/**
 * 
 * @author DNS   ruizc
 *
 */
public class ActivationMetaDataFromMSDS implements ActivationMetaData {

	private Activation activationEsr = null;
	private DeploymentMetaData[] deployments = null;
	private final String[] invalidTerminationReason = {"F","W"};
	
	private gov.va.med.esr.jms.vadir.outboundResponse.
		model.militaryHistory.Activation activation = null;
	
	public ActivationMetaDataFromMSDS(ServicePeriod period,
			gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.Activation activation ) {
		super();
		
		this.processMSDSwrapper(period, activation);
	}
	
	public String getActivationBeginDate() {
		ImpreciseDate date = (this.activation != null && this.activation.getStartDate() != null) ?
				ImpreciseDateUtils.createImpreciseDateWithoutTime(this.activation.getStartDate()) : null;
		return date != null ? date.getStandardFormat() : null;		

	}

	public String getActivationEndDate() {
		ImpreciseDate date = (this.activation != null && this.activation.getEndDate() != null) ?
				ImpreciseDateUtils.createImpreciseDateWithoutTime(this.activation.getEndDate()) : null;
		return date != null ? date.getStandardFormat() : null;		
	}

	public String getDataSource() {
		// ESR generates since VADIR knows nothing about this
		// Activation/deployment is a VADIR concept
		return MHDataSource.VADIR.getCode();
	}

	public DeploymentMetaData[] getDeployments() {
		return this.deployments;
	}

	public Activation getEntity() {
		return this.activationEsr;
	}

	public String getNamedContingency() {
		// not provided by VADIR
		return null;
	}

	public String getSpecialOperation() {
		// not provided by VADIR
		return null;
	}

	public String getTerminationReason() {
		return this.activation != null ? activation.getTerminationRsn() : null;
	}

	public void setEntity(Activation entity) {
		this.activationEsr = entity;

	}
	
	private void processMSDSwrapper(ServicePeriod period,  
			gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.Activation activation) {

		this.activation = activation;
		if (this.activation == null)
			return;
		// Deployments			
		List deployments = new ArrayList();
		
		// Need to make sure activation exists since it is parent to deployment
		if (activation != null & period != null && period.getDeployments() != null) {
			List deps = period.getDeployments();
			Date actStart = activation.getStartDate();
			Date actEnd = activation.getEndDate();
			// Load Deployments with temporal association
			for (Iterator itr = deps.iterator(); itr.hasNext();) {
				Deployment deployment = (Deployment)itr.next();
				if (StringUtils.contains(this.invalidTerminationReason, 
						deployment.getTerminationRsn()))
					continue;			
				
				Date start = deployment.getStartDate();
				Date end = deployment.getEndDate();
				if (isInRange(start,end,actStart, actEnd)) {
					DeploymentMetaDataFromMSDS data = new DeploymentMetaDataFromMSDS(deployment);		
					deployments.add(data);
				}
			}
			this.deployments = (DeploymentMetaData[])deployments.toArray(new DeploymentMetaData[0]);			
		}
	}
	
	private boolean isInRange(Date startDate,Date endDate,Date lower_range,Date upper_range) {
		if( startDate != null && endDate != null && lower_range != null &&  upper_range != null && 
				(startDate.equals(endDate) || startDate.before(endDate))&& 
				(lower_range.equals(upper_range) || lower_range.before(upper_range))) 
		{
			if( (startDate.equals(lower_range) || startDate.after(lower_range)) && 
					(startDate.equals(upper_range) || startDate.before(upper_range)) &&
					(endDate.equals(lower_range)   || endDate.after(lower_range)) && 
					(endDate.equals(upper_range)   || endDate.before(upper_range)) ) 
			{
				return true;
			}
		}
		return false;
	}	  
}
