/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.validator;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.AbstractValidator;
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes

// Messaging Classes
import gov.va.med.esr.common.builder.entity.MilitaryServiceEpisodeMetaData;

/**
 * @author Martin Francisco
 */
public class MilitaryServiceEpisodeMetaDataValidator
    extends AbstractValidator
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6780994642390156081L;

	public MilitaryServiceEpisodeMetaDataValidator()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((MilitaryServiceEpisodeMetaData)input);
    }

    private void validateMinimumDataProvided(
        MilitaryServiceEpisodeMetaData input) throws ValidatorException
    {
        if(input.getServiceBranch() == null)
        {
            throw new ValidatorException("Service Branch is required");
        }
    }
}