/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.validator;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.AbstractValidator;
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes

// Messaging Classes
import gov.va.med.esr.common.builder.entity.CDProcedureMetaData;

/**
 * @author Martin Francisco
 */
public class CDProcedureMetaDataValidator
    extends AbstractValidator
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 7537188358953395539L;

	public CDProcedureMetaDataValidator()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang.Object)
     */
    protected void processValidate(Object input) throws ValidatorException
    {
        this.validateMinimumDataProvided((CDProcedureMetaData)input);
    }

    private void validateMinimumDataProvided(CDProcedureMetaData input)
        throws ValidatorException
    {
        if(input.getAffectedExtremity() == null)
        {
            throw new ValidatorException("Affected Extremity is required");
        }
    }
}