/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes
import java.util.List;

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZE2;

// Common Classes
import gov.va.med.esr.common.builder.entity.VAPensionMetaData;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;


// Messaging Class

/**
 * @author Meena palaniappan
 */
public class VAPensionMetaDataFromZE2
    extends AbstractMetaData
    implements VAPensionMetaData
{
    private MonetaryBenefitAward entity;

    private ZE2 ze2;
    
    //VBA Pension Data Group
	private String effectiveDate = null;
	private String terminationDate = null;
	private String awardReasonCode = null;
	private String[] terminationReasonCodes = new String[4];


    public VAPensionMetaDataFromZE2(ZE2 ze2)
    {
        super();
        this.ze2 = ze2;
        
        if (ze2 != null )
        	parseZe2();
    }
    

    private void parseZe2()
    {
    	if(ze2.getPensionAwardReasonCode() != null){
    		this.awardReasonCode = ze2.getPensionAwardReasonCode().split("\\~")[0];    		
    		this.effectiveDate = ze2.getPensionDate().split("\\~")[0];    		
    	}
    	/*else{
    		if(ze2.getPensionTerminatedReason() != null){
    			//Pension Award Termination Codes 1  4
            	String[] values = ze2.getPensionTerminatedReason().split("\\|");
            	
            	for (int i = 0; i< values.length; i++)
            	{
               		if (i >3 )
            			break; //codes does not go more than 4
 
               		terminationReasonCodes[i] = values[i].split("\\~")[0];
            	}
            	
            	this.terminationDate = ze2.getPensionTerminatedDate(); 
    		}
    	} */
    }
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MonetaryBenefitAwardMetaData#getEntity()
     */
    public MonetaryBenefitAward getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MonetaryBenefitAwardMetaData#setEntity(gov.va.med.esr.common.model.ee.MonetaryBenefitAward)
     */
    public void setEntity(MonetaryBenefitAward entity)
    {
        this.entity = entity;
    }

	public String getAwardReasonCode() {
		return awardReasonCode;
	}


	public String getEffectiveDate() {
		return effectiveDate;
	}

	public String getTerminationDate() {
		return terminationDate;
	}

	public String[] getTerminationReasonCodes() {
		return terminationReasonCodes;
	}


}