/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes
import java.util.List;

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.OBX;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.VAPensionMetaData;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;


// Messaging Class

/**
 * @author George Tsai
 */
public class VAPensionMetaDataFromOBX
    extends AbstractMetaData
    implements VAPensionMetaData
{

	//OBSERVATION IDENTIFIER for VBA Pension Data
	private static final String AAC = "AAC";
	private static final String PENSION = "Pension";
	
    private MonetaryBenefitAward entity;

    private List obxs;
    
    //VBA Pension Data Group
	private String effectiveDate = null;
	private String terminationDate = null;
	private String awardReasonCode = null;
	private String[] terminationReasonCodes = new String[4];


    public VAPensionMetaDataFromOBX(List obxs)
    {
        super();
        this.obxs = obxs;
        
        if (obxs != null && obxs.size() > 0)
        	parseObxs();
    }

    private void parseObxs()
    {
    	OBX pensionObx = null;
    	
        for (int index = 0; index < ((obxs == null) ? 0 : obxs.size()); index++)
        {
            OBX current = (OBX) obxs.get(index);
            CE id = CE.create(current.getObservationID(), current
                    .getComponentDelimiter());            
            if ((id != null) && AAC.equals(super.getValue(id.getID()))
                    && PENSION.equals(super.getValue(id.getText())))
            {
            	pensionObx = current;
            }
        }
        
        if (pensionObx != null)
        {	
        	
            if (pensionObx.getObservationValue() != null )
            {
            	//Pension Award Termination Codes 1  4
            	String[] values = pensionObx.getObservationValue().split("\\|");
            	
            	for (int i = 0; i< values.length; i++)
            	{
               		if (i >3 )
            			break; //codes does not go more than 4
 
               		terminationReasonCodes[i] = values[i].split("\\~")[0];
            		
            	}
            }
            
        	//Pension Award Effective Date
        	this.effectiveDate = pensionObx.getLastObservationNormalValueDate();
        
        	//Pension Award Termination Date
        	this.terminationDate = pensionObx.getObservationDate();
        
        	//Pension Award Reason Code
        	this.awardReasonCode = pensionObx.getProducerID();
            
/*           	((MonetaryBenefitAwardBuilder)this.monetaryBenefitAwardBuilder).buildVAPension(
           			entity, terminationCodes, awardEffectDt, terminationDt, awardReasonCd);*/
        }
 
    }
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MonetaryBenefitAwardMetaData#getEntity()
     */
    public MonetaryBenefitAward getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MonetaryBenefitAwardMetaData#setEntity(gov.va.med.esr.common.model.ee.MonetaryBenefitAward)
     */
    public void setEntity(MonetaryBenefitAward entity)
    {
        this.entity = entity;
    }

	public String getAwardReasonCode() {
		return awardReasonCode;
	}


	public String getEffectiveDate() {
		return effectiveDate;
	}

	public String getTerminationDate() {
		return terminationDate;
	}

	public String[] getTerminationReasonCodes() {
		return terminationReasonCodes;
	}


}