/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZDP;
import gov.va.med.fw.hl7.segment.ZEM;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.XAD;
import gov.va.med.esr.common.builder.datatype.metadata.XTN;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.EmploymentMetaData;
import gov.va.med.esr.common.builder.entity.PhoneMetaData;
import gov.va.med.esr.common.builder.entity.SpouseMetaData;
import gov.va.med.esr.common.model.person.Spouse;

// Messaging Classes

public class SpouseMetaDataFromZDP
    extends RelationMetaDataFromZDP
    implements SpouseMetaData
{
    private Spouse entity;
    
    private ZDP zdp;
    
    EmploymentMetaData employment;
    
    AddressMetaData address;
    
    PhoneMetaData phone;

    public SpouseMetaDataFromZDP(ZDP zdp,ZEM zem)
    {
        super(zdp);
        
        this.zdp = zdp;
        employment = (zdp == null) ? null : new EmploymentMetaDataFromZEM(zem);

        XAD xad = (zdp == null) ? null : XAD.create(zdp.getAddress(), zdp
                .getComponentDelimiter());       
        address = (xad == null) ? null : new AddressMetaDataFromXAD(xad);
        
        XTN xtn = (zdp == null) ? null : XTN.create(zdp.getHomePhone(), zdp
                .getComponentDelimiter());
        phone = (xtn == null) ? null : new PhoneMetaDataFromXTN(xtn);
     }


    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpouseMetaData#setEntity(gov.va.med.esr.common.model.person.Spouse)
     */
    public void setEntity(Spouse entity)
    {
        this.entity = entity;
    }


    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.SpouseMetaData#getEntity()
     */
    public Spouse getEntity()
    {
        return entity;
    }

    public String getMaidenName()
    {
        return (this.zdp == null) ? null : this.zdp.getSpouseMaidenName();
    }

    public EmploymentMetaData getEmployment() {
        return employment;
    }

    public AddressMetaData getAddress() {
        return address;
    }

    public PhoneMetaData getPhone() {
        return phone;
    }
 
}