/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZDP;
import gov.va.med.fw.hl7.segment.ZEM;

// Common Classes
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.EmploymentMetaData;
import gov.va.med.esr.common.builder.entity.PhoneMetaData;
import gov.va.med.esr.common.builder.entity.SpouseMetaData;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.service.external.person.SpouseInfo;

// Messaging Classes

public class SpouseMetaDataFromIVM
    extends RelationMetaDataFromIVM
    implements SpouseMetaData
{
    private Spouse entity;
    
    //private ZDP zdp;
    
    private SpouseInfo ivmSpouseInfo;
    
    EmploymentMetaData employment;  
    
    AddressMetaData address;
    
    PhoneMetaData phone;
    

    public SpouseMetaDataFromIVM(SpouseInfo ivmSpouseInfo)
    {
        super(ivmSpouseInfo);
        
        this.ivmSpouseInfo = ivmSpouseInfo;
        
        employment = (ivmSpouseInfo == null) ? null : new EmploymentMetaDataFromIVM(ivmSpouseInfo.getEmployments());
        
     }


    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpouseMetaData#setEntity(gov.va.med.esr.common.model.person.Spouse)
     */
    public void setEntity(Spouse entity)
    {
        this.entity = entity;
    }


    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.SpouseMetaData#getEntity()
     */
    public Spouse getEntity()
    {
        return entity;
    }

    public String getMaidenName()
    {
        return (this.ivmSpouseInfo == null) ? null : this.ivmSpouseInfo.getMaidenName();
    }

    public EmploymentMetaData getEmployment() {
        return employment;
    }
    
    public AddressMetaData getAddress() {
        return null;
    }

    public PhoneMetaData getPhone() {
        return null;
    }
    
 
}