/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZDP;
import gov.va.med.fw.hl7.segment.ZEM;
import gov.va.med.fw.hl7.segment.ZIC;
import gov.va.med.fw.hl7.segment.ZIR;
import gov.va.med.fw.hl7.segment.ZMT;

// Common Classes
import gov.va.med.esr.common.builder.entity.PersonMetaData;
import gov.va.med.esr.common.builder.entity.SpouseFinancialsMetaData;
import gov.va.med.esr.common.builder.entity.SpouseMetaData;
import gov.va.med.esr.common.model.financials.SpouseFinancials;

// Messaging Classes

public class SpouseFinancialsMetaDataFromZDP
    extends FinancialInformationMetaDataFromZIC
    implements SpouseFinancialsMetaData
{
    private SpouseFinancials entity;

    private ZIR veteranZIR;

    private PersonMetaData reportedOn;
    private SpouseMetaData reportedOnSpouse;

    public SpouseFinancialsMetaDataFromZDP(
        ZDP zdp,
        ZIC zic,
        ZIR zir,
        ZEM zem,
        ZIR veteranZIR, ZMT zmt)
    {
        super(zic, zmt);

        this.veteranZIR = veteranZIR;

        this.reportedOnSpouse = (zdp == null) ? null : new SpouseMetaDataFromZDP(
            zdp,zem);
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpouseFinancialsMetaData#getEntity()
     */
    public SpouseFinancials getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpouseFinancialsMetaData#setEntity(gov.va.med.esr.common.model.financials.SpouseFinancials)
     */
    public void setEntity(SpouseFinancials entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpouseFinancialsMetaData#getLivedWithPatient()
     */
    public String getLivedWithPatient()
    {
        return (this.veteranZIR == null) ? null : this.veteranZIR
            .getLivedWithPatient();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpouseFinancialsMetaData#getReportedOn()
     */
    public PersonMetaData getReportedOn()
    {
        return this.reportedOn;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpouseFinancialsMetaData#getReportedOnSpouse()
     */
    public SpouseMetaData getReportedOnSpouse()
    {
        return this.reportedOnSpouse;
    }
}