/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes
import gov.va.med.esr.common.builder.entity.PersonMetaData;
import gov.va.med.esr.common.builder.entity.SpouseFinancialsMetaData;
import gov.va.med.esr.common.builder.entity.SpouseMetaData;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.service.external.person.SpouseFinancialsInfo;

// Messaging Classes

public class SpouseFinancialsMetaDataFromIVM
    extends FinancialInformationMetaDataFromIVM
    implements SpouseFinancialsMetaData
{
    private SpouseFinancials entity;    
    
    private SpouseFinancialsInfo spouseFinancialsInfo;

    private PersonMetaData reportedOn;
    private SpouseMetaData reportedOnSpouse;

    public SpouseFinancialsMetaDataFromIVM(SpouseFinancialsInfo spouseFinancialsInfo, String incomeYear)
    {
        super(spouseFinancialsInfo, incomeYear);

        this.spouseFinancialsInfo = spouseFinancialsInfo;

        this.reportedOnSpouse = (spouseFinancialsInfo == null) ? null : new SpouseMetaDataFromIVM(spouseFinancialsInfo.getSpouse());
            
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpouseFinancialsMetaData#getEntity()
     */
    public SpouseFinancials getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpouseFinancialsMetaData#setEntity(gov.va.med.esr.common.model.financials.SpouseFinancials)
     */
    public void setEntity(SpouseFinancials entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpouseFinancialsMetaData#getLivedWithPatient()
     */
    public String getLivedWithPatient()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpouseFinancialsMetaData#getReportedOn()
     */
    public PersonMetaData getReportedOn()
    {
        return this.reportedOn;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpouseFinancialsMetaData#getReportedOnSpouse()
     */
    public SpouseMetaData getReportedOnSpouse()
    {
        return this.reportedOnSpouse;
    }
}