/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZPD;

// Common Classes
import gov.va.med.esr.common.builder.entity.SpinalCordInjuryMetaData;
import gov.va.med.esr.common.model.ee.SpinalCordInjury;

// Messaging Classes

/**
 * @author DNS   CHENJ2
 */
public class SpinalCordInjuryMetaDataFromZPD
    extends AbstractMetaData
    implements SpinalCordInjuryMetaData
{
    private SpinalCordInjury entity;

    private ZPD zpd;

    public SpinalCordInjuryMetaDataFromZPD(ZPD zpd)
    {
        super();

        this.zpd = zpd;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpinalCordInjury#getEntity()
     */
    public SpinalCordInjury getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpinalCordInjury#setEntity(gov.va.med.esr.common.model.ee.SpinalCordInjury)
     */
    public void setEntity(SpinalCordInjury entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.SpinalCordInjuryMetaData#getType()
     */
    public String getType()
    {
        return (this.zpd == null) ? null : this.zpd.getSpinalCordInjury();
    }

    public String getDeterminationFacility() {
        return null;
    }
}