/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes
import java.util.List;

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZRD;
import gov.va.med.fw.hl7.segment.ZSP;

// Common Classes
import gov.va.med.esr.common.builder.entity.RatedDisabilityMetaData;
import gov.va.med.esr.common.builder.entity.ServiceConnectionAwardMetaData;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;

// Messaging Class

/**
 * @author Martin Francisco
 */
public class ServiceConnectionAwardMetaDataFromZSP
    extends AbstractMetaData
    implements ServiceConnectionAwardMetaData
{
    private ServiceConnectionAward entity;

    private ZSP zsp;

    private RatedDisabilityMetaData[] ratedDisabilities;

    public ServiceConnectionAwardMetaDataFromZSP(ZSP zsp, List zrds)
    {
        super();

        this.zsp = zsp;

        this.ratedDisabilities = this.buildRatedDisabilities(zrds);
    }

    private RatedDisabilityMetaData[] buildRatedDisabilities(List zrds)
    {
        int size = (zrds == null) ? 0 : zrds.size();
        RatedDisabilityMetaData[] results = new RatedDisabilityMetaData[size];
        for(int index = 0; index < size; index++)
        {
            results[index] = new RatedDisabilityMetaDataFromZRD((ZRD)zrds
                .get(index));
        }
        return results;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ServiceConnectionAwardMetaData#getEntity()
     */
    public ServiceConnectionAward getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ServiceConnectionAwardMetaData#setEntity(gov.va.med.esr.common.model.ee.ServiceConnectionAward)
     */
    public void setEntity(ServiceConnectionAward entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ServiceConnectionAwardMetaData#getAwardDate()
     */
    public String getAwardDate()
    {
        return (this.zsp == null) ? null : this.zsp
            .getServiceConnectedAwardDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ServiceConnectionAwardMetaData#getPermanentAndTotal()
     */
    public String getPermanentAndTotal()
    {
        return (this.zsp == null) ? null : this.zsp.getPermanentAndTotal();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ServiceConnectionAwardMetaData#getPermanentAndTotalEffectiveDate()
     */
    public String getPermanentAndTotalEffectiveDate()
    {
        return (this.zsp == null) ? null : this.zsp
            .getPermanentAndTotalEffectiveDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ServiceConnectionAwardMetaData#getRatedDisabilities()
     */
    public RatedDisabilityMetaData[] getRatedDisabilities()
    {
        return this.ratedDisabilities;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ServiceConnectionAwardMetaData#getServiceConnected()
     */
    public String getServiceConnected()
    {
        return (this.zsp == null) ? null : this.zsp.getServiceConnected();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ServiceConnectionAwardMetaData#getServiceConnectedPercentage()
     */
    public String getServiceConnectedPercentage()
    {
        return (this.zsp == null) ? null : this.zsp
            .getServiceConnectedPercentage();
    }

    public String getCombinedSCPercentEffectiveDate()
    {
        return (this.zsp == null) ? null : this.zsp
            .getCombinedSCPercentEffectiveDate();
    }    
        
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ServiceConnectionAwardMetaData#getUnemployable()
     */
    public String getUnemployable()
    {
        return (this.zsp == null) ? null : this.zsp.getUnemployable();
    }
}