package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.SSNMetaData;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.fw.hl7.segment.ZDP;
/**
 * 
 * @author Rajiv Patnaik
 * Created on Aug 11, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class SSNMetaDataFromZDP extends AbstractSSNMetaData implements SSNMetaData
{
    private ZDP zdp;
     
    public SSNMetaDataFromZDP(ZDP zdp)
    {
        this.zdp = zdp;
    }
 
    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.SSNMetaData#getSSNText()
     */
    public String getSSNText()
    {
        return zdp == null? null : zdp.getSSN();
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.SSNMetaData#getSSNType()
     */
    public String getSSNType()
    {
    	String ssnType = null;
        if (getSSNText() != null)
        {
            //If the SSN ends with P, it is a PseudoSSN
            if (getSSNText().endsWith("P"))
            {
                ssnType = SSNType.CODE_PSEUDO.getName();
            } else
            {
                ssnType = SSNType.CODE_ACTIVE.getName();
            }
        }
        return ssnType;         
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.SSNMetaData#getPseudoSSNReason()
     */
    public String getPseudoSSNReason()
    {
        return (zdp == null)? null :zdp.getPseudoSSNReason();
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.SSNMetaData#getSSNVerificationStatus()
     */
    public String getSSNVerificationStatus()
    {
        return (zdp == null)? null :zdp.getSSNVerificationStatus();    
    }
    
}
