package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.SSNMetaData;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.fw.hl7.segment.PID;
import gov.va.med.fw.hl7.segment.ZPD;
/**
 * 
 * @author Rajiv Patnaik
 * Created on Aug 11, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class SSNMetaDataFromPID extends AbstractSSNMetaData implements SSNMetaData
{
    private PID pid;
    private ZPD zpd;
    
    public SSNMetaDataFromPID(PID pid,ZPD zpd)
    {
        this.pid = pid;
        this.zpd = zpd;
    }


    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.SSNMetaData#getSSNText()
     */
    public String getSSNText()
    {
        return (pid == null )?null: pid.getSSN();
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.SSNMetaData#getSSNType()
     */
    public String getSSNType()
    {
    	//For veteran, the SSNType will always be official. The Pseudo SSN reason will
    	//dtermine if it is offcial or pseudo SSN
        return SSNType.CODE_ACTIVE.getName();
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.SSNMetaData#getPseudoSSNReason()
     */
    public String getPseudoSSNReason()
    {
        //If not a pseudo SSN, will return null
        return (zpd == null)?null: zpd.getPseudoSSNReason();
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.SSNMetaData#getSSAVerificationStatus()
     * 
     */
    public String getSSNVerificationStatus()
    {
        return null;    
    }
  

}
