package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.PN;
import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.builder.entity.RelationMetaData;
import gov.va.med.esr.common.builder.entity.SSNMetaData;
import gov.va.med.esr.common.model.lookup.NameType;

import gov.va.med.fw.hl7.segment.ZDP;

/**
 * Class representing the Relation info from ZDP. This is common to Spouse and
 * Dependent
 * 
 * @author Rajiv Patnaik Created on Oct 12, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class RelationMetaDataFromZDP extends AbstractMetaData implements
        RelationMetaData
{

    private ZDP zdp;


    public RelationMetaDataFromZDP(ZDP zdp)
    {
        super();

        this.zdp = zdp;
    }

 
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.RelationMetaData#getBirthRecord()
     */
    public String getDOB()
    {
        return (zdp == null) ? null:zdp.getBirthDate();
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.RelationMetaData#getGender()
     */
    public String getGender()
    {
        return (this.zdp == null) ? null : this.zdp.getSex();        
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.RelationMetaData#getName()
     */
    public NameMetaData getName()
    {
        return (zdp == null) ? null : new NameMetaDataFromPNWithType(PN
                .create(zdp.getDependentName(), zdp.getComponentDelimiter()), null);
        
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.RelationMetaData#getSsn()
     */
    public SSNMetaData getSsn()
    {
        return (this.zdp == null) ? null : new SSNMetaDataFromZDP(zdp);
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.RelationMetaData#getEndDate()
     */
    public String getEndDate()
    {
        return (this.zdp == null) ? null : this.zdp.getInactivationDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.RelationMetaData#getStartDate()
     */
    public String getStartDate()
    {
        return (this.zdp == null) ? null : this.zdp.getDependentDate();
    }    
}