package gov.va.med.esr.common.builder.entity.metaData;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.builder.entity.RelationMetaData;
import gov.va.med.esr.common.builder.entity.SSNMetaData;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.service.external.person.RelationInfo;

import gov.va.med.fw.hl7.segment.ZDP;

/**
 * Class representing the Relation info from ZDP. This is common to Spouse and
 * Dependent
 * 
 * @author Rajiv Patnaik Created on Oct 12, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class RelationMetaDataFromIVM extends AbstractMetaData implements
        RelationMetaData
{

	private String impreciseDateFormat ="yyyyMMdd";
	
	private RelationInfo ivmRelationInfo;
	


    public RelationMetaDataFromIVM(RelationInfo ivmRelationInfo)
    {
        super();

        this.ivmRelationInfo = ivmRelationInfo;
    }

 
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.RelationMetaData#getBirthRecord()
     */
    public String getDOB()
    {
        return (ivmRelationInfo == null) ? null:toStrImpreciseDateFormat(toImpreciseDateFormat(ivmRelationInfo.getDob()));
        
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.RelationMetaData#getGender()
     */
    public String getGender()
    {
        return (this.ivmRelationInfo == null) ? null : this.ivmRelationInfo.getGender();        
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.RelationMetaData#getName()
     */
    public NameMetaData getName()
    {
        return (ivmRelationInfo == null) ? null : new NameMetaDataFromIVM(ivmRelationInfo);
        
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.RelationMetaData#getSsn()
     */
    public SSNMetaData getSsn()   
    {
    	if(ivmRelationInfo != null && ivmRelationInfo.getSsns() != null){
    		return new SSNMetaDataFromIVM(ivmRelationInfo.getSsns().getSsn()[0]);    		
    	}
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.RelationMetaData#getEndDate()
     */
    public String getEndDate()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.RelationMetaData#getStartDate()
     */
    public String getStartDate()
    {
        return (this.ivmRelationInfo == null) ? null : this.ivmRelationInfo.getStartDate();
    }  
    
    private String toStrImpreciseDateFormat(Date date) {
        if (date != null) {
            SimpleDateFormat format = new SimpleDateFormat(impreciseDateFormat);
            return format.format(date);        
        }
        return "";
    }
    
    private Date toImpreciseDateFormat(String stringDate) {
        if (stringDate != null) {
            Date date;
			try {
				date = new SimpleDateFormat(impreciseDateFormat).parse(stringDate);
				return date;
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return null;
			}                    
        }
        return null;
    }
}