/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZEN;

// Common Classes
import gov.va.med.esr.common.builder.entity.ReceivedEnrollmentMetaData;
import gov.va.med.esr.common.model.ee.ReceivedEnrollment;

// Messaging Classes

public class ReceivedEnrollmentMetaDataFromZEN
    extends AbstractMetaData
    implements ReceivedEnrollmentMetaData
{
    private ReceivedEnrollment entity;

    private ZEN zen;

    public ReceivedEnrollmentMetaDataFromZEN(ZEN zen)
    {
        super();

        this.zen = zen;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEnrollmentMetaData#getEntity()
     */
    public ReceivedEnrollment getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEnrollmentMetaData#setEntity(gov.va.med.esr.common.model.ee.ReceivedEnrollment)
     */
    public void setEntity(ReceivedEnrollment entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEnrollmentMetaData#getCalculationSource()
     */
    public String getCalculationSource()
    {
        return (this.zen == null) ? null : this.zen.getEnrollmentSource();
    }


    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEnrollmentMetaData#getEffectiveDate()
     */
    public String getEffectiveDate()
    {
        return (this.zen == null) ? null : this.zen.getEffectiveDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEnrollmentMetaData#getEndDate()
     */
    public String getEndDate()
    {
        return (this.zen == null) ? null : this.zen.getEnrollmentEndDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEnrollmentMetaData#getEnrollmentDate()
     */
    public String getEnrollmentDate()
    {
        return (this.zen == null) ? null : this.zen.getEnrollmentDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEnrollmentMetaData#getFacilityReceived()
     */
    public String getFacilityReceived()
    {
        return (this.zen == null) ? null : this.zen.getFacilityReceived();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEnrollmentMetaData#getOverrideFlag()
     */
    public String getOverrideFlag()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEnrollmentMetaData#getPriorityGroup()
     */
    public String getPriorityGroup()
    {
        return (this.zen == null) ? null : this.zen.getEnrollmentPriority();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEnrollmentMetaData#getPrioritySubGroup()
     */
    public String getPrioritySubGroup()
    {
        return (this.zen == null) ? null : this.zen.getEnrollmentSubGroup();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEnrollmentMetaData#getStatus()
     */
    public String getStatus()
    {
        return (this.zen == null) ? null : this.zen.getEnrollmentStatus();
    }
}