/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZEL;
import gov.va.med.fw.hl7.segment.ZPD;

// Common Classes
import gov.va.med.esr.common.builder.entity.ReceivedEligibilityMetaData;
import gov.va.med.esr.common.model.ee.ReceivedEligibility;

// Messaging Classes

public class ReceivedEligibilityMetaDataFromZEL
    extends AbstractMetaData
    implements ReceivedEligibilityMetaData
{
    private ReceivedEligibility entity;

    private ZEL zel;
    private ZPD zpd;

    public ReceivedEligibilityMetaDataFromZEL(ZEL zel, ZPD zpd)
    {
        super();

        this.zel = zel;
        this.zpd = zpd;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEligibilityMetaData#getEntity()
     */
    public ReceivedEligibility getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEligibilityMetaData#setEntity(gov.va.med.esr.common.model.ee.ReceivedEligibility)
     */
    public void setEntity(ReceivedEligibility entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ReceivedEligibilityMetaData#getType()
     */
    public String getType()
    {
        return (this.zel == null) ? null : this.zel.getEligibilityCode();
    }
    
    public String getAlliedCountryOrFederalAgency()
    {
        return (this.zpd == null) ? null : this.zpd.getAlliedCountryOrFederalAgency();
    }
    
    //This is for VOA only and it means that the applicant uploaded an attachment
    public boolean  isVoaHasAttachment()
    {
    	return (this.zpd == null || this.zpd.getVoaAttachmentIndicator() == null)? false : this.zpd.getVoaAttachmentIndicator().equals("1");
    }
    
}