/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZRD;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.RatedDisabilityMetaData;
import gov.va.med.esr.common.model.ee.RatedDisability;

// Messaging Class

/**
 * @author Martin Francisco
 */
public class RatedDisabilityMetaDataFromZRD
    extends AbstractMetaData
    implements RatedDisabilityMetaData
{
    private RatedDisability entity;

    private ZRD zrd;

    private CE disability;

    public RatedDisabilityMetaDataFromZRD(ZRD zrd)
    {
        super();

        this.zrd = zrd;

        this.disability = (zrd == null) ? null : CE.create(zrd
            .getDisabilityCondition(), zrd.getComponentDelimiter());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.RatedDisabilityMetaData#getEntity()
     */
    public RatedDisability getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.RatedDisabilityMetaData#setEntity(gov.va.med.esr.common.model.ee.RatedDisability)
     */
    public void setEntity(RatedDisability entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.RatedDisabilityMetaData#getDisability()
     */
    public String getDisability()
    {
        return (this.disability == null) ? null : super
            .getValue(this.disability.getID());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.RatedDisabilityMetaData#getPercentage()
     */
    public String getPercentage()
    {
        return (this.zrd == null) ? null : this.zrd.getDisabilityPercentage();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.RatedDisabilityMetaData#getServiceConnected()
     */
    public String getServiceConnected()
    {
        return (this.zrd == null) ? null : this.zrd.getServiceConnected();
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.RatedDisabilityMetaData#getDiagnosticExtremity()
     */
    public String getDiagnosticExtremity()
    {
        return (this.zrd == null) ? null : this.zrd.getDiagnosticExtremity();
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.RatedDisabilityMetaData#getRatedDisabilityOrigEffectiveDate()
     */
    public String getRatedDisabilityOrigEffectiveDate()
    {
        return (this.zrd == null) ? null : this.zrd.getRatedDisabilityOrigEffectiveDate();    
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.RatedDisabilityMetaData#getRatedDisabilityCurrentEffectiveDate()
     */
    public String getRatedDisabilityCurrentEffectiveDate()
    {
        return (this.zrd == null) ? null : this.zrd.getRatedDisabilityCurrentEffectiveDate();    
    }
    
    
}