/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZEL;

// Common Classes
import gov.va.med.esr.common.builder.entity.RadiationExposureMetaData;
import gov.va.med.esr.common.model.ee.RadiationExposure;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class RadiationExposureMetaDataFromZEL
    extends AbstractMetaData
    implements RadiationExposureMetaData
{
    private RadiationExposure entity;

    private ZEL zel;

    public RadiationExposureMetaDataFromZEL(ZEL zel)
    {
        super();

        this.zel = zel;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.RadiationExposureMetaData#getEntity()
     */
    public RadiationExposure getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.RadiationExposureMetaData#setEntity(gov.va.med.esr.common.model.ee.RadiationExposure)
     */
    public void setEntity(RadiationExposure entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc) 
     * 
     * @see gov.va.med.esr.messaging.builder.entity.RadiationExposureMetaData#getExposureDate()
     */
    public String getExposureDate()
    {
        //Currently not transmitted and not used
        return (this.zel == null) ? null : this.zel
            .getRadiationRegistrationDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.RadiationExposureMetaData#getExposureMethod()
     */
    public String getExposureMethod()
    {
        return (this.zel == null) ? null : this.zel
            .getRadiationExposureMethod();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.RadiationExposureMetaData#getIndicator()
     */
    public String getIndicator()
    {
        return (this.zel == null) ? null : this.zel.getRadiationExposure();
    }
}