/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.RaceMetaData;
import gov.va.med.esr.common.model.person.Race;
import gov.va.med.fw.hl7.constants.DelimeterConstants;

// Messaging Classes

/**
 * Race is defined in PID-10: for example
 * 
 * "2028-9-SLF~~0005~2028-9~~CDC|2054-5-SLF~~0005~2054-5~~CDC|2106-3-SLF~~0005~2106-3~~CDC"
 *
 * The current definition of the PID segment lists Race as sequence 10 and

   Ethnicity as sequence 22.  Both fields have a data type of composite element

   (CE), which is defined as a field broken down by 6 components.  Because this

   data type does not allow for the ability to encode the collection method,

   the values sent will be encoded with the collection method.  These values

   will be placed into the first triplet (components 1 to 3).

 

   The HL7 standard states that the second triplet (components 4 to 6) is

   reserved for governmentally assigned codes.  For our purposes, we will use

   the CDC values in the second triplet.  Note that the collection method is

   not carried/implied within the second triplet.

 *
 */
public class RaceMetaDataFromCE
    extends AbstractMetaData
    implements RaceMetaData
{
    /**
     * Encoding field delimiter for Race
     */
    private static final String RACE_ENCODING_DELIMITER = "-";
    
    private Race entity;

    private CE ce;
    
    private String raceType = null;
    
    private String collectionMethod = null;
    
    public RaceMetaDataFromCE(CE ce)
    {        super();

        this.ce = ce;
        
        parseIDField();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.RaceMetaData#getEntity()
     */
    public Race getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.RaceMetaData#setEntity(gov.va.med.esr.common.model.person.Name)
     */
    public void setEntity(Race entity)
    {
        this.entity = entity;
    }

    
    /*
     * The ID component should contain the ethnicity type encoded with the collection method:
     * "2028-9-SLF"
     */
    private void parseIDField() {
        String ID = (this.ce == null) ? null : super.getValue(this.ce.getID());
        
        if (ID != null && ID.length() > 0) {
            // The Race Type should be the substring before the last delimiter "-"
            int delimiterIndex = ID.lastIndexOf(RACE_ENCODING_DELIMITER);
        
            if (delimiterIndex != -1) {
                setRaceType(ID.substring(0, delimiterIndex));
                setCollectionMethod(ID.substring(delimiterIndex+1));
            }
            else 
                setRaceType(ID);
        }   
    }

    public String getCollectionMethod() {
        return collectionMethod;
    }

    private void setCollectionMethod(String collectionMethod) {
        this.collectionMethod = collectionMethod;
    }

    public String getRaceType() {
        return raceType;
    }

    private void setRaceType(String raceType) {
        this.raceType = raceType;
    }
 }