/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.ZMH;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.PurpleHeartMetaData;
import gov.va.med.esr.common.model.ee.PurpleHeart;

// Messaging Classes

public class PurpleHeartMetaDataFromZMH
    extends AbstractMetaData
    implements PurpleHeartMetaData
{
    private PurpleHeart entity;

    private MSH msh;

    private CE indicator;

    public PurpleHeartMetaDataFromZMH(ZMH zmh, MSH msh)
    {
        super();
        
        this.msh = msh;
        this.indicator = (zmh == null) ? null : CE.create(zmh
            .getServiceIndicator(), zmh.getComponentDelimiter());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PurpleHeartMetaData#getEntity()
     */
    public PurpleHeart getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PurpleHeartMetaData#setEntity(gov.va.med.esr.common.model.ee.PurpleHeart)
     */
    public void setEntity(PurpleHeart entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PurpleHeartMetaData#getIndicator()
     */
    public String getIndicator()
    {
        return (this.indicator == null) ? null : super.getValue(this.indicator
            .getID());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PurpleHeartMetaData#getRejectionRemark()
     */
    public String getRejectionRemark()
    {
        return (this.indicator == null) ? null : super.getValue(this.indicator
            .getCodingSystem());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PurpleHeartMetaData#getStatus()
     */
    public String getStatus()
    {
        return (this.indicator == null) ? null : super.getValue(this.indicator
            .getText());
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.PurpleHeartMetaData#getFacility()
     */
    public String getFacility()
    {
        return (this.msh == null) ? null : this.msh.getSendingFacility();        
    }
    
}