/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.IN1;

// Common Classes
import gov.va.med.esr.common.builder.entity.PrivateInsuranceMetaData;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class PrivateInsuranceMetaDataFromIN1
    extends InsurancePolicyMetaDataFromIN1
    implements PrivateInsuranceMetaData
{
    private PrivateInsurance entity;

    private IN1 in1;

    public PrivateInsuranceMetaDataFromIN1(IN1 in1, String site)
    {
        super(in1, site);

        this.in1 = in1;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PrivateInsuranceMetaData#getEntity()
     */
    public PrivateInsurance getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PrivateInsuranceMetaData#setEntity(gov.va.med.esr.common.model.insurance.PrivateInsurance)
     */
    public void setEntity(PrivateInsurance entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PrivateInsuranceMetaData#getCompanyName()
     */
    public String getCompanyName()
    {
        return (this.in1 == null) ? null : this.in1.getInsuranceCompanyName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PrivateInsuranceMetaData#getEffectiveDate()
     */
    public String getEffectiveDate()
    {
        return (this.in1 == null) ? null : this.in1.getPlanEffectiveDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PrivateInsuranceMetaData#getExpirationDate()
     */
    public String getExpirationDate()
    {
        return (this.in1 == null) ? null : this.in1.getPlanExpirationDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PrivateInsuranceMetaData#getGroupName()
     */
    public String getGroupName()
    {
        return (this.in1 == null) ? null : this.in1.getGroupName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PrivateInsuranceMetaData#getGroupNumber()
     */
    public String getGroupNumber()
    {
        return (this.in1 == null) ? null : this.in1.getGroupNumber();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PrivateInsuranceMetaData#getPolicyNumber()
     */
    public String getPolicyNumber()
    {
        return (this.in1 == null) ? null : this.in1.getPolicyNumber();
    }
}