/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZTA;

// Common Classes

// Messaging Classes
import gov.va.med.esr.common.builder.datatype.metadata.TN;

public class PhoneMetaDataFromZTA
    extends PhoneMetaDataFromTN
{
    private ZTA zta;
    private String type;

    public PhoneMetaDataFromZTA(TN tn, ZTA zta, String type)
    {
        super(tn);

        this.zta = zta;
        this.type = type;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PhoneMetaData#getType()
     */
    public String getType()
    {
        return this.type;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.PhoneMetaData#getEndDate()
     */
    public String getEndDate()
    {
        return (this.zta == null) ? null : this.zta
            .getTemporaryAddressEndDate();
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.PhoneMetaData#getStartDate()
     */
    public String getStartDate()
    {
        return (this.zta == null) ? null : this.zta
            .getTemporaryAddressStartDate();
    }
}