/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.XTN;
import gov.va.med.esr.common.builder.entity.PhoneMetaData;
import gov.va.med.esr.common.model.party.Phone;

// Messaging Class

/**
 * @author Martin Francisco
 */
public class PhoneMetaDataFromXTN extends AbstractMetaData implements
        PhoneMetaData
{
    private Phone entity;

    private XTN xtn;

    public PhoneMetaDataFromXTN(XTN xtn)
    {
        super();

        this.xtn = xtn; 
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PhoneMetaData#getEntity()
     */
    public Phone getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PhoneMetaData#setEntity(gov.va.med.esr.common.model.party.Phone)
     */
    public void setEntity(Phone entity)
    {
        this.entity = entity;
    }
  
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PhoneMetaData#getPhoneNumber()
     */
    public String getPhoneNumber()
    {
        return super.getValue((this.xtn == null) ? null : this.xtn.getNumber());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PhoneMetaData#getType()
     */
    public String getType()
    {
        return null;
    }

    public String getTelecomUseCode()
    {
        return super
                .getValue((this.xtn == null) ? null : this.xtn.getUseCode());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PhoneMetaData#getEndDate()
     */
    public String getEndDate()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PhoneMetaData#getStartDate()
     */
    public String getStartDate()
    {
        return null;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.PhoneMetaData#getChangeSite()
     */
    public String getChangeSite()
    {
        return null;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.PhoneMetaData#getChangeSource()
     */
    public String getChangeSource()
    {
        return null;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.PhoneMetaData#getChangeDate()
     */
    public String getChangeDate()
    {
        return null;
    }
}