/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.RF1;

// Common Classes

// Messaging Classes
import gov.va.med.esr.common.builder.datatype.metadata.EI;
import gov.va.med.esr.common.builder.datatype.metadata.XTN;

public class PhoneMetaDataFromPID
    extends PhoneMetaDataFromXTN
{
    private RF1 rf1;
    private String type;
    private EI referralID;
    

    public PhoneMetaDataFromPID(XTN xtn, RF1 rf1, String type)
    {
        super(xtn);

        this.rf1 = rf1;
        this.type = type;
    } 
    
    public PhoneMetaDataFromPID(XTN xtn,  RF1 rf1)
    {
        super(xtn);

        this.rf1 = rf1;
        this.referralID = (rf1 == null) ? null : EI.create(rf1
                .getOriginalReferralID(), rf1.getComponentDelimiter());        
    }    

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.PhoneMetaData#getChangeSite()
     */
    public String getChangeSite()
    {
        return (this.referralID == null) ? null : super
                .getValue(this.referralID.getEntityID());
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.PhoneMetaData#getChangeSource()
     */
    public String getChangeSource()
    {
        return (this.referralID == null) ? null : super
                .getValue(this.referralID.getNamespaceID());
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.PhoneMetaData#getChangeDate()
     */
    public String getChangeDate()
    {
        return (this.rf1 == null) ? null : this.rf1.getEffectiveDate();
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PhoneMetaData#getType()
     */
    public String getType()
    {
        return this.type;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.PhoneMetaData#getStartDate()
     */
    public String getStartDate()
    {
        return null;
        //return (this.rf1 == null) ? null : this.rf1.getEffectiveDate();
    }
}