/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZDP;
import gov.va.med.fw.hl7.segment.ZEM;

import gov.va.med.esr.common.builder.datatype.metadata.PN;
import gov.va.med.esr.common.builder.entity.BirthRecordMetaData;
import gov.va.med.esr.common.builder.entity.DeathRecordMetaData;
import gov.va.med.esr.common.builder.entity.EthnicityMetaData;
import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.builder.entity.PersonMetaData;
import gov.va.med.esr.common.builder.entity.RaceMetaData;
import gov.va.med.esr.common.builder.entity.SSNMetaData;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.person.Person;

public class PersonMetaDataFromZDP
    extends AbstractMetaData
    implements PersonMetaData
{
    private Person entity;

    private ZDP zdp;
    private ZEM zem;

    private BirthRecordMetaData birthRecord;
    private NameMetaData[] names;

    public PersonMetaDataFromZDP(ZDP zdp, ZEM zem)
    {
        super();

        this.zdp = zdp;
        this.zem = zem;

        this.birthRecord = (zdp == null)
            ? null
            : new BirthRecordMetaDataFromZDP(zdp);
        this.names = (zdp == null)
            ? null
            : new NameMetaData[] { new NameMetaDataFromPNWithType(PN.create(zdp
                .getDependentName(), zdp.getComponentDelimiter()), NameType.LEGAL_NAME.getName()) };
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#getEntity()
     */
    public Person getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#setEntity(gov.va.med.esr.common.model.person.Person)
     */
    public void setEntity(Person entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#getBirthRecord()
     */
    public BirthRecordMetaData getBirthRecord()
    {
        return this.birthRecord;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#getDeathRecord()
     */
    public DeathRecordMetaData getDeathRecord()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#getGender()
     */
    public String getGender()
    {
        return (this.zdp == null) ? null : this.zdp.getSex();
    }


    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#getMaritalStatus()
     */
    public String getMaritalStatus()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#getNames()
     */
    public NameMetaData[] getNames()
    {
        return this.names;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#getNationalICN()
     */
    public String getNationalICN()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#getPreferredFacility()
     */
    public String getPreferredFacility()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#getRace()
     */
    public String getRace()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#getSSN()
     */
    public SSNMetaData[] getSsns()
    {
        return null;
        
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#getVeteran()
     */
    public String getVeteran()
    {
        return null;
    }
    
    public String getWasPrisonerOfWar()
    {
        return null;
    } 
    
    public String getAppointmentRequestOn1010EZ()
    {
        return null;
    }
    public String getAppointmentRequestDate()
    {
        return null;
    }
    
    public String getEmergencyResponseType()
    {
        return null;
    }  
   
    public NameMetaData getMotherName() {
        return null;
    }

    public NameMetaData getFatherName() {
        return null;   
    }

    public RaceMetaData[] getRaces() {
        return null;
    }

    public EthnicityMetaData getEthnicity() {
        return null;
    }

    public String getReligion() {
        return null;
    }

    public String getMothersMaidenName() {
        return null;
    }

}