/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZIC;
import gov.va.med.fw.hl7.segment.ZIO;

// Common Classes
import gov.va.med.esr.common.builder.entity.PatientVisitSummaryMetaData;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;

// Messaging Classes

public class PatientVisitSummaryMetaDataFromZIO
    extends AbstractMetaData
    implements PatientVisitSummaryMetaData
{
    private PatientVisitSummary entity;

    private ZIC zic;
    private ZIO zio;
    private String facilityVisited;

    public PatientVisitSummaryMetaDataFromZIO(
        ZIO zio,
        ZIC zic,
        String facilityVisited)
    {
        super();

        this.zic = zic;
        this.zio = zio;
        this.facilityVisited = facilityVisited;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PatientVisitSummaryMetaData#getEntity()
     */
    public PatientVisitSummary getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PatientVisitSummaryMetaData#setEntity(gov.va.med.esr.common.model.financials.PatientVisitSummary)
     */
    public void setEntity(PatientVisitSummary entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PatientVisitSummaryMetaData#getFacilityVisited()
     */
    public String getFacilityVisited()
    {
        return this.facilityVisited;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PatientVisitSummaryMetaData#getIncomeYear()
     */
    public String getIncomeYear()
    {
        return (this.zic == null) ? null : this.zic.getIncomeYear();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PatientVisitSummaryMetaData#getInpatientDays()
     */
    public String getInpatientDays()
    {
        return (this.zio == null) ? null : this.zio
            .getInpatientDaysSinceLastMeansTest();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PatientVisitSummaryMetaData#getLastVisitDate()
     */
    public String getLastVisitDate()
    {
        return (this.zio == null) ? null : this.zio.getLastVisitDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PatientVisitSummaryMetaData#getOutpatientDays()
     */
    public String getOutpatientDays()
    {
        return (this.zio == null) ? null : this.zio
            .getOutpatientDaysSinceLastMeansTest();
    }
}