/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.OBX;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.datatype.metadata.HD;
import gov.va.med.esr.common.builder.datatype.metadata.XCN;
import gov.va.med.esr.common.builder.entity.NoseThroatRadiumMetaData;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class NoseThroatRadiumMetaDataFromOBX
    extends AbstractMetaData
    implements NoseThroatRadiumMetaData
{
    private NoseThroatRadium entity;

    private OBX obx;

    private CE ce;
    private HD hd;
    private String diagnosedWithCancer;
    private String fromAviatorServiceBefore1955;
    private String fromSubmarinerServiceBefore1965;
    private String receivingTreatment;

    public NoseThroatRadiumMetaDataFromOBX(OBX obx)
    {
        super();

        this.obx = obx;

        this.ce = (obx == null) ? null : CE
            .create(obx.getObservationMethod(), obx.getComponentDelimiter());

        XCN xcn = (obx == null) ? null : XCN.create(obx
            .getResponsibleObserver(), obx.getComponentDelimiter(), obx
            .getSubComponentDelimiter());
        this.hd = (xcn == null) ? null : xcn.getAssigningFacility();

        if(obx != null)
        {
            this.processObservations(CE.create(obx.getObservationValue(), obx
                .getRepeatDelimiter(), obx.getComponentDelimiter()));
        }
    }

    private void processObservations(CE[] observations)
    {
        if(observations != null)
        {
            for(int index = 0; index < observations.length; index++)
            {
                CE value = observations[index];
                String id = super.getValue(value.getID());

                if("1".equals(id))
                {
                    this.receivingTreatment = "T";
                }
                else if("2".equals(id))
                {
                    this.fromAviatorServiceBefore1955 = "1";
                }
                else if("3".equals(id))
                {
                    this.fromSubmarinerServiceBefore1965 = "1";
                }
                else if("4".equals(id))
                {
                    this.diagnosedWithCancer = "1";
                }
                else if("5".equals(id))
                {
                    this.receivingTreatment = "F";
                }
                else if("6".equals(id))
                {
                    this.fromAviatorServiceBefore1955 = "0";
                }
                else if("7".equals(id))
                {
                    this.fromSubmarinerServiceBefore1965 = "0";
                }
                else if("8".equals(id))
                {
                    this.diagnosedWithCancer = "0";
                }
                else if("9".equals(id))
                {
                    this.receivingTreatment = "U";
                }
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NoseThroatRadiumMetaData#getEntity()
     */
    public NoseThroatRadium getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NoseThroatRadiumMetaData#setEntity(gov.va.med.esr.common.model.ee.NoseThroatRadium)
     */
    public void setEntity(NoseThroatRadium entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NoseThroatRadiumMetaData#getDiagnosedWithCancer()
     */
    public String getDiagnosedWithCancer()
    {
        return this.diagnosedWithCancer;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NoseThroatRadiumMetaData#getFromAviatorServiceBefore1955()
     */
    public String getFromAviatorServiceBefore1955()
    {
        return this.fromAviatorServiceBefore1955;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NoseThroatRadiumMetaData#getFromSubmarinerServiceBefore1965()
     */
    public String getFromSubmarinerServiceBefore1965()
    {
        return this.fromSubmarinerServiceBefore1965;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NoseThroatRadiumMetaData#getReceivingTreatment()
     */
    public String getReceivingTreatment()
    {
        return this.receivingTreatment;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NoseThroatRadiumMetaData#getVerificationDate()
     */
    public String getVerificationDate()
    {
        return (this.obx == null) ? null : this.obx.getObservationDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NoseThroatRadiumMetaData#getVerificationFacility()
     */
    public String getVerificationFacility()
    {
        return (this.obx == null) ? null : this.obx.getProducerID();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NoseThroatRadiumMetaData#getVerificationMethod()
     */
    public String getVerificationMethod()
    {
        return (this.ce == null) ? null : super.getValue(this.ce.getID());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ClinicalDeterminationMetaData#getDeterminationDate()
     */
    public String getDeterminationDate()
    {
        return (this.obx == null) ? null : this.obx
            .getLastObservationNormalValueDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ClinicalDeterminationMetaData#getDeterminationFacility()
     */
    public String getDeterminationFacility()
    {
        return (this.hd == null) ? null : super.getValue(this.hd
            .getUniversalID());
    }
}