/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.XPN;
import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.model.person.Name;

// Messaging Classes

public class NameMetaDataFromXPN
    extends AbstractMetaData
    implements NameMetaData
{
    private Name entity;

    private XPN xpn;

    public NameMetaDataFromXPN(XPN xpn)
    {
        super();

        this.xpn = xpn;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getEntity()
     */
    public Name getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#setEntity(gov.va.med.esr.common.model.person.Name)
     */
    public void setEntity(Name entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getDegree()
     */
    public String getDegree()
    {
        return (this.xpn == null) ? null : super.getValue(this.xpn.getDegree());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getFamilyName()
     */
    public String getFamilyName()
    {
        return (this.xpn == null) ? null : super.getValue(this.xpn
            .getFamilyName());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getGivenName()
     */
    public String getGivenName()
    {
        return (this.xpn == null) ? null : super.getValue(this.xpn
            .getGivenName());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getMiddleName()
     */
    public String getMiddleName()
    {
        return (this.xpn == null) ? null : super.getValue(this.xpn
            .getMiddleName());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getPrefix()
     */
    public String getPrefix()
    {
        return (this.xpn == null) ? null : super.getValue(this.xpn.getPrefix());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getSuffix()
     */
    public String getSuffix()
    {
        return (this.xpn == null) ? null : super.getValue(this.xpn.getSuffix());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getType()
     */
    public String getType()
    {
        return (this.xpn == null) ? null : super.getValue(this.xpn
            .getTypeCode());
    }
}