/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.PN;
import gov.va.med.esr.common.builder.datatype.metadata.ST;
import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.fw.hl7.constants.DelimeterConstants;

// Messaging Classes

public class NameMetaDataFromST
extends AbstractMetaData
    implements NameMetaData
{
    private Name entity;
 
    private NameMetaDataFromPN metaDataFromPN;

    public NameMetaDataFromST(ST st)
    {
        super();
        
        this.metaDataFromPN = new NameMetaDataFromPN(convertToPN(st));
    }
 
    /**
     * Convert Mother's and Father's name in the format of (Last, First middle suffix)
     * in to the PN format (LASTNAME^FIRST^MIDDLE^SUFFIX^^DEGREE)
     * 
     * @param st
     * @return
     */
    private PN convertToPN(ST st) {
        if (st == null || st.getValue() == null)
            return null;
        
        String pnString = st.getValue().replace(',', DelimeterConstants.DEFAULT_FIELD_DELIMITER.charAt(0));
        pnString = pnString.replace(' ', DelimeterConstants.DEFAULT_FIELD_DELIMITER.charAt(0));
        
        // CCR 10300 - call specific PN method for handling parent name
        return PN.createForParent(pnString, DelimeterConstants.DEFAULT_FIELD_DELIMITER);
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getEntity()
     */
    public Name getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#setEntity(gov.va.med.esr.common.model.person.Name)
     */
    public void setEntity(Name entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getDegree()
     */
    public String getDegree()
    {
        return this.metaDataFromPN.getDegree();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getFamilyName()
     */
    public String getFamilyName()
    {
       return this.metaDataFromPN.getFamilyName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getGivenName()
     */
    public String getGivenName()
    {
        return this.metaDataFromPN.getGivenName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getMiddleName()
     */
    public String getMiddleName()
    {
        return this.metaDataFromPN.getMiddleName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getPrefix()
     */
    public String getPrefix()
    {
        return this.metaDataFromPN.getPrefix();
   }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getSuffix()
     */
    public String getSuffix()
    {
        return this.metaDataFromPN.getSuffix();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.NameMetaData#getType()
     */
    public String getType()
    {
        return null;
    }
}