/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZEL;

// Common Classes
import gov.va.med.esr.common.builder.entity.MonetaryBenefitAwardMetaData;
import gov.va.med.esr.common.builder.entity.MonetaryBenefitMetaData;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;

// Messaging Class

/**
 * @author Martin Francisco
 */
public class MonetaryBenefitAwardMetaDataFromZEL
    extends AbstractMetaData
    implements MonetaryBenefitAwardMetaData
{
    private MonetaryBenefitAward entity;

    private ZEL zel;

    private MonetaryBenefitMetaData[] monetaryBenefits;

    public MonetaryBenefitAwardMetaDataFromZEL(ZEL zel)
    {
        super();

        this.zel = zel;

        this.monetaryBenefits = this.buildMonetaryBenefits(zel);
    }

    private MonetaryBenefitMetaData[] buildMonetaryBenefits(ZEL zel)
    {
        if(zel == null)
        {
            return new MonetaryBenefitMetaData[0];
        }
        else
        {
            MonetaryBenefitMetaData[] results = new MonetaryBenefitMetaData[4];
            results[0] = new MonetaryBenefitMetaDataFromZELPosition(zel
                .getReceivingAABenefits(), MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getCode());
            results[1] = new MonetaryBenefitMetaDataFromZELPosition(zel
                .getReceivingHouseboundBenefits(), MonetaryBenefitType.CODE_HOUSEBOUND.getCode());
            results[2] = new MonetaryBenefitMetaDataFromZELPosition(zel
                .getReceivingVaPension(), MonetaryBenefitType.CODE_VA_PENSION.getCode());
            results[3] = new MonetaryBenefitMetaDataFromZELPosition(zel
                .getReceivingVaDisability(), MonetaryBenefitType.CODE_DISABILITY_COMPENSATION.getCode());
            return results;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MonetaryBenefitAwardMetaData#getEntity()
     */
    public MonetaryBenefitAward getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MonetaryBenefitAwardMetaData#setEntity(gov.va.med.esr.common.model.ee.MonetaryBenefitAward)
     */
    public void setEntity(MonetaryBenefitAward entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MonetaryBenefitAwardMetaData#getCheckAmount()
     */
    public String getCheckAmount()
    {
        return (this.zel == null) ? null : this.zel
            .getTotalAnnualVaCheckAmount();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MonetaryBenefitAwardMetaData#getMonetaryBenefits()
     */
    public MonetaryBenefitMetaData[] getMonetaryBenefits()
    {
        return this.monetaryBenefits;
    }
}