/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZEL;

// Common Classes
import gov.va.med.esr.common.builder.entity.MilitarySexualTraumaMetaData;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class MilitarySexualTraumaMetaDataFromZEL
    extends AbstractMetaData
    implements MilitarySexualTraumaMetaData
{
    private MilitarySexualTrauma entity;

    private ZEL zel;

    public MilitarySexualTraumaMetaDataFromZEL(ZEL zel)
    {
        super();

        this.zel = zel;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitarySexualTraumaMetaData#getEntity()
     */
    public MilitarySexualTrauma getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitarySexualTraumaMetaData#setEntity(gov.va.med.esr.common.model.ee.MilitarySexualTrauma)
     */
    public void setEntity(MilitarySexualTrauma entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitarySexualTraumaMetaData#getStatus()
     */
    public String getStatus()
    {
        return (this.zel == null) ? null : this.zel.getMstStatus();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitarySexualTraumaMetaData#getStatusChangeDate()
     */
    public String getStatusChangeDate()
    {
        return (this.zel == null) ? null : this.zel.getMstStatusChangeDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ClinicalDeterminationMetaData#getDeterminationDate()
     */
    public String getDeterminationDate()
    {
        return (this.zel == null) ? null : this.zel.getMstStatusChangeDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ClinicalDeterminationMetaData#getDeterminationFacility()
     */
    public String getDeterminationFacility()
    {
        return (this.zel == null) ? null : this.zel
            .getMstStatusDeterminingSite();
    }
}