package gov.va.med.esr.common.builder.entity.metaData;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.esr.common.builder.entity.ConflictExperienceMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceEpisodeMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceSiteRecordMetaData;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.ZMH;
import gov.va.med.fw.hl7.segment.ZPD;
import gov.va.med.fw.hl7.segment.ZSP;

/**
 * 
 * @author Rajiv Patnaik Created on Jul 20, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class MilitaryServiceSiteRecordMetaDataFromZMH implements
        MilitaryServiceSiteRecordMetaData
{

    private MilitaryServiceSiteRecord entity;

    private ConflictExperienceMetaData[] conflictExperiences;

    private MilitaryServiceEpisodeMetaData[] militaryServiceEpisodes;

    private MSH msh;

    private ZSP zsp;

    private ZPD zpd;

    public MilitaryServiceSiteRecordMetaDataFromZMH(MSH msh, ZSP zsp, ZPD zpd,
            List zmhs)
    {
        super();

        this.msh = msh;
        this.zpd = zpd;
        this.zsp = zsp;

        this.processZMHs(zmhs, (zpd == null) ? null : zpd
                .getFilipinoVeteranProof());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceSiteRecordMetaData#getEntity()
     */
    public MilitaryServiceSiteRecord getEntity()
    {
        return entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceSiteRecordMetaData#setEntity(gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord)
     */
    public void setEntity(MilitaryServiceSiteRecord entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceSiteRecordMetaData#getConflictExperiences()
     */
    public ConflictExperienceMetaData[] getConflictExperiences()
    {
        return conflictExperiences;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceSiteRecordMetaData#getMilitaryServiceEpisodes()
     */
    public MilitaryServiceEpisodeMetaData[] getMilitaryServiceEpisodes()
    {
        return militaryServiceEpisodes;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceSiteRecordMetaData#getServicePeriod()
     */
    public String getServicePeriod()
    {
        return (this.zsp == null) ? null : this.zsp.getServicePeriod();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceSiteRecordMetaData#getFilipinoVeteranProof()
     */
    public String getFilipinoVeteranProof()
    {
        return (zpd == null) ? null : zpd.getFilipinoVeteranProof();
    }

    public String getSite()
    {
        return (this.msh == null) ? null : this.msh.getSendingFacility();
    }
        
    private void processZMHs(List zmhs, String filipinoVeteranProof)
    {
        List conflictExperiences = new ArrayList(7);
        List militaryServiceEpisodes = new ArrayList(zmhs.size());// CCR8369 we may get many militaryServiceEpisodes

        for (int index = 0; index < ((zmhs == null) ? 0 : zmhs.size()); index++)
        {
            ZMH zmh = (ZMH) zmhs.get(index);
            String type = zmh.getMilitaryHistoryType();
            if (this.isCombatExperience(type))
            {
                conflictExperiences.add(new ConflictExperienceMetaDataFromZMH(
                        zmh));
            } else if (this.isMilitaryServiceEpisode(type))
            {
                militaryServiceEpisodes
                        .add(new MilitaryServiceEpisodeMetaDataFromZMH(zmh));
            } else if (this.isConflictExperience(type))
            {
                conflictExperiences.add(new ConflictExperienceMetaDataFromZMH(
                        zmh));
            }
        }

        this.conflictExperiences = (ConflictExperienceMetaData[]) conflictExperiences
                .toArray(new ConflictExperienceMetaData[0]);

        this.militaryServiceEpisodes = (MilitaryServiceEpisodeMetaData[]) militaryServiceEpisodes
                .toArray(new MilitaryServiceEpisodeMetaData[0]);
    }

    private boolean isCombatExperience(String type)
    {
        return (MetaDataConstants.COMBAT_EXPERIENCE.equals(type));
    }

    private boolean isConflictExperience(String type)
    {
        return (MetaDataConstants.CONFLICT_EXPERIENCE_VIET.equals(type)
                || MetaDataConstants.CONFLICT_EXPERIENCE_LEBA.equals(type)
                || MetaDataConstants.GREN_CONFLICT_EXPERIENCE.equals(type)
                || MetaDataConstants.CONFLICT_EXPERIENCE_PANA.equals(type)
                || MetaDataConstants.CONFLICT_EXPERIENCE_GULF.equals(type)
                || MetaDataConstants.CONFLICT_EXPERIENCE_SOMA.equals(type) || MetaDataConstants.CONFLICT_EXPERIENCE_YUGO
                .equals(type));
    }

    private boolean isMilitaryServiceEpisode(String type)
    {
        return (MetaDataConstants.MILITARY_EPISODE_SL.equals(type)
                || MetaDataConstants.MILITARY_EPISODE_SNL.equals(type) || MetaDataConstants.MILITARY_EPISODE_SNNL
                .equals(type)|| MetaDataConstants.MILITARY_EPISODE_MSD.equals(type));
    }

    
}