/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes
import java.util.List;

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.ZEL;
import gov.va.med.fw.hl7.segment.ZPD;
import gov.va.med.fw.hl7.segment.ZSP;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.MilitaryServiceMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceSiteRecordMetaData;
import gov.va.med.esr.common.model.ee.MilitaryService;

// Messaging Classes

public class MilitaryServiceMetaDataFromZEL
    extends AbstractMetaData
    implements MilitaryServiceMetaData
{
    private MilitaryService entity;
    
    private ZEL zel;

    private CE wasPrisonerOfWarIndicator;
    private MilitaryServiceSiteRecordMetaData militaryServiceSiteRecord;

    public MilitaryServiceMetaDataFromZEL(MSH msh, ZEL zel, ZSP zsp, ZPD zpd, List zmhs)
    {
        super();
        
        this.zel = zel;
        this.militaryServiceSiteRecord = new 
        	MilitaryServiceSiteRecordMetaDataFromZMH(msh,zsp,zpd,zmhs);
        
    }

    /**
     * @return Returns the militaryServiceSiteRecord.
     */
    public MilitaryServiceSiteRecordMetaData getMilitaryServiceSiteRecord()
    {
        return militaryServiceSiteRecord;
    }


    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceMetaData#getEntity()
     */
    public MilitaryService getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceMetaData#setEntity(gov.va.med.esr.common.model.ee.MilitaryService)
     */
    public void setEntity(MilitaryService entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceMetaData#getCombatVeteranEligibilityEndDate()
     */
    public String getCombatVeteranEligibilityEndDate()
    {
        return (this.zel == null) ? null : this.zel
            .getCombatVeteranEligibilityEndDate();
    }


    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceMetaData#getDisabilityRetirementStatus()
     */
    public String getDisabilityRetirementStatus()
    {
        return (this.zel == null) ? null : this.zel
                .getDisabilityRetirementFromMilitary();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceMetaData#getDischargeDueToDisability()
     */
    public String getDischargeDueToDisability()
    {
        return (this.zel == null) ? null : this.zel
                .getDischargeDueToDisability();
    }

     /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceMetaData#getWasPrisonerOfWar()
     */
    public String getWasPrisonerOfWar()
    {
       
        return (this.wasPrisonerOfWarIndicator == null) ? null : super
            .getValue(this.wasPrisonerOfWarIndicator.getID());
    }
    
}