/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZMH;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.datatype.metadata.DR;
import gov.va.med.esr.common.builder.datatype.metadata.TS;
import gov.va.med.esr.common.builder.entity.MilitaryServiceEpisodeMetaData;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;

// Messaging Classes

public class MilitaryServiceEpisodeMetaDataFromZMH extends AbstractMetaData
        implements MilitaryServiceEpisodeMetaData
{
    private MilitaryServiceEpisode entity;

    private CE indicator;

    private DR dateRange;
    
    private ZMH zmh;

    public MilitaryServiceEpisodeMetaDataFromZMH(ZMH zmh)
    {
        super();

        this.indicator = (zmh == null) ? null : CE.create(zmh
                .getServiceIndicator(), zmh.getComponentDelimiter());
        this.dateRange = (zmh == null) ? null : DR.create(zmh
                .getServiceEntryDateAndServiceSeparationDate(), zmh
                .getComponentDelimiter(), zmh.getSubComponentDelimiter());
        
        this.zmh = zmh;
    }

    private String getValueFromTS(TS value)
    {
        return (value == null) ? null : super.getValue(value.getDateTime());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceEpisodeMetaData#getEntity()
     */
    public MilitaryServiceEpisode getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceEpisodeMetaData#setEntity(gov.va.med.esr.common.model.ee.MilitaryServiceEpisode)
     */
    public void setEntity(MilitaryServiceEpisode entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceEpisodeMetaData#getDischargeType()
     */
    public String getDischargeType()
    {
        return (this.indicator == null) ? null : super.getValue(this.indicator
                .getCodingSystem());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceEpisodeMetaData#getEndDate()
     */
    public String getEndDate()
    {
        return (this.dateRange == null) ? null : this
                .getValueFromTS(this.dateRange.getEndDateTime());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceEpisodeMetaData#getServiceBranch()
     */
    public String getServiceBranch()
    {
        return (this.indicator == null) ? null : super.getValue(this.indicator
                .getID());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceEpisodeMetaData#getServiceNumber()
     */
    public String getServiceNumber()
    {
        return (this.indicator == null) ? null : super.getValue(this.indicator
                .getText());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MilitaryServiceEpisodeMetaData#getStartDate()
     */
    public String getStartDate()
    {
        return (this.dateRange == null) ? null : this
                .getValueFromTS(this.dateRange.getStartDateTime());
    }
    
    public String getServiceComponent()
    {
        return (this.zmh == null ) ? null : this.zmh.getServiceComponent();
    }
}