/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.IN1;

// Common Classes
import gov.va.med.esr.common.builder.entity.MedicareMetaData;
import gov.va.med.esr.common.model.insurance.Medicare;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class MedicareMetaDataFromIN1
    extends InsurancePolicyMetaDataFromIN1
    implements MedicareMetaData
{
    private Medicare entity;

    private IN1 planA;
    private IN1 planB;
    private boolean isEnrolledInPartA;
 
    public MedicareMetaDataFromIN1(IN1 planA, IN1 planB, boolean isEnrolledInPartA, String site)
    {
        super((planA == null) ? planB : planA, site);

        this.isEnrolledInPartA = isEnrolledInPartA;
        this.planA = planA;
        this.planB = planB;
    }    
    
    public MedicareMetaDataFromIN1(IN1 planA, IN1 planB)
    {
        super( ((planA == null) ? planB : planA), null);

        this.planA = planA;
        this.planB = planB;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MedicareMetaData#getEntity()
     */
    public Medicare getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MedicareMetaData#setEntity(gov.va.med.esr.common.model.insurance.Medicare)
     */
    public void setEntity(Medicare entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MedicareMetaData#getEnrolledInPartA()
     */
    public String getEnrolledInPartA()
    {
        return isEnrolledInPartA == false? "0" : "1";
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MedicareMetaData#getEnrolledInPartB()
     */
    public String getEnrolledInPartB()
    {
        return (this.planB == null) ? "0" : "1";
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MedicareMetaData#getMedicareNumber()
     */
    public String getMedicareClaimNumber()
    {
        return (this.planA == null) ? ((this.planB == null) ? null : this.planB.getPolicyNumber()) : this.planA.getPolicyNumber();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MedicareMetaData#getPartAEffectiveDate()
     */
    public String getPartAEffectiveDate()
    {
        return (this.planA == null) ? null : this.planA.getPlanEffectiveDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MedicareMetaData#getPartBEffectiveDate()
     */
    public String getPartBEffectiveDate()
    {
        return (this.planB == null) ? null : this.planB.getPlanEffectiveDate();
    }
}