/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZPD;

// Common Classes
import gov.va.med.esr.common.builder.entity.MedicaidFactorMetaData;
import gov.va.med.esr.common.model.ee.MedicaidFactor;

// Messaging Classes

public class MedicaidFactorMetaDataFromZPD
    extends AbstractMetaData
    implements MedicaidFactorMetaData
{
    private MedicaidFactor entity;

    private ZPD zpd;

    public MedicaidFactorMetaDataFromZPD(ZPD zpd)
    {
        super();

        this.zpd = zpd;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MedicaidFactorMetaData#getEntity()
     */
    public MedicaidFactor getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MedicaidFactorMetaData#setEntity(gov.va.med.esr.common.model.ee.MedicaidFactor)
     */
    public void setEntity(MedicaidFactor entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MedicaidFactorMetaData#getEligibleForMedicaid()
     */
    public String getEligibleForMedicaid()
    {
        return (this.zpd == null) ? null : this.zpd.getEligibleForMedicaid();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.MedicaidFactorMetaData#getLastUpdateDate()
     */
    public String getLastUpdateDate()
    {
        return (this.zpd == null) ? null : this.zpd.getMedicaidLastAskedDate();
    }
}