/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.IN1;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.PN;
import gov.va.med.esr.common.builder.entity.InsuranceSubscriberMetaData;
import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.model.insurance.InsuranceSubscriber;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class InsuranceSubscriberMetaDataFromIN1
    extends AbstractMetaData
    implements InsuranceSubscriberMetaData
{
    private InsuranceSubscriber entity;

    private IN1 in1;

    private NameMetaData name;

    public InsuranceSubscriberMetaDataFromIN1(IN1 in1)
    {
        super();

        this.in1 = in1;

        this.name = (in1 == null) ? null : new NameMetaDataFromPNWithType(PN.create(in1
            .getInsuredName(), in1.getComponentDelimiter()), "L");
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.InsuranceSubscriberMetaData#getEntity()
     */
    public InsuranceSubscriber getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.InsuranceSubscriberMetaData#setEntity(gov.va.med.esr.common.model.insurance.InsuranceSubscriber)
     */
    public void setEntity(InsuranceSubscriber entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.InsuranceSubscriberMetaData#getName()
     */
    public NameMetaData getName()
    {
        return this.name;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.InsuranceSubscriberMetaData#getRelationship()
     */
    public String getRelationship()
    {
        return (this.in1 == null) ? null : this.in1
            .getInsuredRelationToPatient();
    }
}