/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.IN1;

// Common Classes

// Messaging Classes
import gov.va.med.esr.common.builder.datatype.metadata.AD;
import gov.va.med.esr.common.builder.datatype.metadata.TN;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.InsurancePlanMetaData;
import gov.va.med.esr.common.builder.entity.InsurancePolicyMetaData;
import gov.va.med.esr.common.builder.entity.InsuranceSubscriberMetaData;
import gov.va.med.esr.common.builder.entity.PhoneMetaData;
import gov.va.med.esr.common.model.lookup.PhoneType;

/**
 * @author Martin Francisco
 */
public abstract class InsurancePolicyMetaDataFromIN1
    extends AbstractMetaData
    implements InsurancePolicyMetaData
{
    private AddressMetaData address;
    private PhoneMetaData phone;
    private InsurancePlanMetaData plan;
    private InsuranceSubscriberMetaData subscriber;
    private String site;

    public InsurancePolicyMetaDataFromIN1(IN1 in1, String site)
    {
        super();
        
        this.site = site;
        this.address = (in1 == null) ? null : new AddressMetaDataFromAD(AD
            .create(in1.getInsuranceCompanyAddress(), in1
                .getComponentDelimiter()));
        //Added RP 08/29. The InsurancePolicy phone now needs to have a PhoneType
        //This is not received from the message. Default it to BusinessType
        this.phone = (in1 == null) ? null : new PhoneMetaDataFromTN(TN
            .create(in1.getInsuranceCompanyPhoneNumber()),PhoneType.CODE_BUSINESS.getName());
        this.plan = (in1 == null) ? null
            :  new InsurancePlanMetaDataFromIN1(
                in1) ;
        this.subscriber = (in1 == null) ? null
            : new InsuranceSubscriberMetaDataFromIN1(in1);
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.InsurancePolicyMetaData#getAddress()
     */
    public AddressMetaData getAddress()
    {
        return this.address;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.InsurancePolicyMetaData#getPhone()
     */
    public PhoneMetaData getBusinessPhone()
    {
        return this.phone;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.InsurancePolicyMetaData#getPlans()
     */
    public InsurancePlanMetaData getPlan()
    {
        return this.plan;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.InsurancePolicyMetaData#getSubscriber()
     */
    public InsuranceSubscriberMetaData getSubscriber()
    {
        return this.subscriber;
    }
    
    public String getReportSite()
    {
        return this.site;
    }
}